/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import java.util.HashMap;
import java.util.Map;

public class TreeNodeIdManager {
    private static final String TRACEMASK_T = "XBUITIDT";
    private static final String TRACEMASK_F = "XBUITIDF";
    private static final String TRACEMASK_D = "XBUITIDD";
    private static final Object STATIC_LOCK = new Object();
    private static TreeNodeIdManager idManager;
    private final Object INSTANCE_LOCK = new Object();
    private Map idToNodeMap = new HashMap();

    private TreeNodeIdManager() {
        Trace.trace(TRACEMASK_T, "<> TreeNodeIdManager()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Trace.trace(TRACEMASK_T, "<--> TreeNodeIdManager.init()");
        Object object = STATIC_LOCK;
        synchronized (object) {
            if (idManager == null) {
                idManager = new TreeNodeIdManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeNodeIdManager getTreeNodeIdManager() {
        Object object = STATIC_LOCK;
        synchronized (object) {
            return idManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BonsaiTreeNode getNode(String id) {
        Object object = this.INSTANCE_LOCK;
        synchronized (object) {
            return (BonsaiTreeNode)this.idToNodeMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNode(BonsaiTreeNode node) {
        Object object = this.INSTANCE_LOCK;
        synchronized (object) {
            this.idToNodeMap.put(node.getId(), node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deregisterNode(BonsaiTreeNode node) {
        Object object = this.INSTANCE_LOCK;
        synchronized (object) {
            return this.idToNodeMap.remove(node.getId()) != null;
        }
    }
}

